import { world, system } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:stairs', {
        onPlace({ block }) {
            const placed = block.permutation.withState('v360:placed_bit', true)
            block.setPermutation(placed)
        },
        onPlayerInteract: (data) => {
            const block = data.block
            const player = data.player
            const straight = block.permutation.withState('v360:shape', "straight")
            const inner_left = block.permutation.withState('v360:shape', "inner_left")
            const inner_right = block.permutation.withState('v360:shape', "inner_right")
            const outer_left = block.permutation.withState('v360:shape', "outer_left")
            const outer_right = block.permutation.withState('v360:shape', "outer_right")
            if (block.hasTag('v360:stairs_straight') && player.isSneaking) {
                block.setPermutation(inner_left)
            }
            else if (block.hasTag('v360:stairs_inner_left') && player.isSneaking) {
                block.setPermutation(inner_right)
            }
            else if (block.hasTag('v360:stairs_inner_right') && player.isSneaking) {
                block.setPermutation(outer_left)
            }
            else if (block.hasTag('v360:stairs_outer_left') && player.isSneaking) {
                block.setPermutation(outer_right)
            }
            else if (block.hasTag('v360:stairs_outer_right') && player.isSneaking) {
                block.setPermutation(straight)
            }
        }
    })
})